/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util;

import cz.insophy.inplan.util.Localizer;
import cz.insophy.inplan.util.i18n.FsControl;
import cz.insophy.inplan.util.i18n.ResourceBundleTokenResolver;
import cz.insophy.inplan.util.io.CombinedTokenResolver;
import cz.insophy.inplan.util.io.MapTokenResolver;
import cz.insophy.inplan.util.io.TokenReplacingReader;
import cz.insophy.inplan.util.io.TokenResolver;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SqlScriptReader
implements Closeable {
    private static final int IO_BUFFER_SIZE = 4096;
    private final Reader reader;
    private char[] buffer;
    private int bufferPos;
    private int bufferStart = -1;
    private int bufferEnd;
    private boolean endOfFile;
    private boolean insideRemark;
    private boolean blockRemark;
    private boolean skipRemarks;
    private int remarkStart;
    private int linesRead;
    private int prevChar;

    public SqlScriptReader(Reader reader) {
        this.reader = reader;
        this.buffer = new char[8192];
        this.linesRead = 0;
        this.prevChar = -1;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public String readStatement() throws IOException {
        if (this.endOfFile) {
            return null;
        }
        return this.readStatementLoop();
    }

    /*
     * Unable to fully structure code
     */
    private String readStatementLoop() throws IOException {
        this.bufferStart = this.bufferPos;
        c = this.read();
        block7: while (true) {
            if (c < 0) {
                this.endOfFile = true;
                if (this.bufferPos - 1 != this.bufferStart) break;
                return null;
            }
            if (c == 59) break;
            switch (c) {
                case 36: {
                    c = this.read();
                    if (c != 36 || this.bufferPos - this.bufferStart >= 3 && this.buffer[this.bufferPos - 3] > ' ') continue block7;
                    while ((c = this.read()) >= 0 && (c != 36 || (c = this.read()) >= 0 && c != 36)) {
                    }
                    c = this.read();
                    continue block7;
                }
                case 39: {
                    while ((c = this.read()) >= 0 && c != 39) {
                    }
                    c = this.read();
                    continue block7;
                }
                case 34: {
                    while ((c = this.read()) >= 0 && c != 34) {
                    }
                    c = this.read();
                    continue block7;
                }
                case 47: {
                    c = this.read();
                    if (c == 42) {
                        this.startRemark(true);
                        while ((c = this.read()) >= 0) {
                            if (c != 42) continue;
                            c = this.read();
                            if (c < 0) {
                                this.clearRemark();
                                break;
                            }
                            if (c != 47) continue;
                            this.endRemark();
                            break;
                        }
                        c = this.read();
                        continue block7;
                    }
                    if (c != 47) continue block7;
                    this.startRemark(false);
                    do {
                        if ((c = this.read()) >= 0) continue;
                        this.clearRemark();
                        ** GOTO lbl50
                    } while (c != 13 && c != 10);
                    this.endRemark();
lbl50:
                    // 2 sources

                    c = this.read();
                    continue block7;
                }
                case 45: {
                    c = this.read();
                    if (c != 45) continue block7;
                    this.startRemark(false);
                    do {
                        if ((c = this.read()) >= 0) continue;
                        this.clearRemark();
                        ** GOTO lbl62
                    } while (c != 13 && c != 10);
                    this.endRemark();
lbl62:
                    // 2 sources

                    c = this.read();
                    continue block7;
                }
            }
            c = this.read();
        }
        return new String(this.buffer, this.bufferStart, this.bufferPos - 1 - this.bufferStart);
    }

    private void startRemark(boolean block) {
        this.blockRemark = block;
        this.remarkStart = this.bufferPos - 2;
        this.insideRemark = true;
    }

    private void endRemark() {
        this.clearRemark();
        this.insideRemark = false;
    }

    private void clearRemark() {
        if (this.skipRemarks) {
            Arrays.fill(this.buffer, this.remarkStart, this.bufferPos, ' ');
        }
    }

    private int read() throws IOException {
        int r;
        if (this.bufferPos >= this.bufferEnd) {
            return this.readBuffer();
        }
        if ((r = this.buffer[this.bufferPos++]) == 10 || r == 13 && this.prevChar != 10) {
            ++this.linesRead;
        }
        this.prevChar = r;
        return r;
    }

    private int readBuffer() throws IOException {
        if (this.endOfFile) {
            return -1;
        }
        int keep = this.bufferPos - this.bufferStart;
        if (keep > 0) {
            char[] src = this.buffer;
            if (keep + 4096 > src.length) {
                if (src.length >= 0x3FFFFFFF) {
                    throw new IOException("Error in parsing script, statement size exceeds 1G, first 80 characters of statement looks like: " + new String(this.buffer, this.bufferStart, 80));
                }
                this.buffer = new char[src.length * 2];
            }
            System.arraycopy(src, this.bufferStart, this.buffer, 0, keep);
        }
        this.remarkStart -= this.bufferStart;
        this.bufferStart = 0;
        this.bufferPos = keep;
        int len = this.reader.read(this.buffer, keep, 4096);
        if (len == -1) {
            this.bufferEnd = -1024;
            this.endOfFile = true;
            ++this.bufferPos;
            return -1;
        }
        this.bufferEnd = keep + len;
        return this.buffer[this.bufferPos++];
    }

    public boolean isInsideRemark() {
        return this.insideRemark;
    }

    public boolean isBlockRemark() {
        return this.blockRemark;
    }

    public void setSkipRemarks(boolean skipRemarks) {
        this.skipRemarks = skipRemarks;
    }

    public int getLinesRead() {
        return this.linesRead;
    }

    /*
     * Exception decompiling
     */
    public static void runScript(Connection conn, Reader reader) throws SQLException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 11[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void runScript(Connection conn, URL url) throws IOException, SQLException {
        try (InputStreamReader reader = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);){
            SqlScriptReader.runScript(conn, reader);
        }
    }

    public static void runLocalizedScript(@Nonnull Connection conn, @Nonnull Path sqlScript, @Nullable Map<String, String> parameters) throws IOException, SQLException {
        Optional<TokenResolver> resolver = SqlScriptReader.getTokenResolver(sqlScript, parameters);
        String script = Files.readString(sqlScript, StandardCharsets.UTF_8);
        try (StringReader reader = new StringReader(script);){
            if (resolver.isEmpty()) {
                SqlScriptReader.runScript(conn, reader);
            } else {
                TokenReplacingReader replacingReader = new TokenReplacingReader(reader, resolver.get());
                SqlScriptReader.runScript(conn, replacingReader);
            }
        }
    }

    @Nonnull
    private static Optional<TokenResolver> getTokenResolver(@Nonnull Path sqlScript, @Nullable Map<String, String> parameters) {
        MapTokenResolver parametersResolver;
        Optional<ResourceBundle> locBundle = SqlScriptReader.getLocBundle(sqlScript);
        TokenResolver bundleResolver = locBundle.map(ResourceBundleTokenResolver::new).orElse(null);
        MapTokenResolver mapTokenResolver = parametersResolver = parameters != null ? new MapTokenResolver(parameters) : null;
        TokenResolver resolver = parametersResolver != null && bundleResolver != null ? new CombinedTokenResolver(List.of(parametersResolver, bundleResolver)) : (parametersResolver != null ? parametersResolver : bundleResolver);
        return Optional.ofNullable(resolver);
    }

    @Nonnull
    private static Optional<ResourceBundle> getLocBundle(@Nonnull Path sqlScript) {
        String suffix;
        String bn = sqlScript.getFileName().toString();
        if (bn.endsWith(suffix = ".sql")) {
            bn = bn.substring(0, bn.length() - suffix.length());
        }
        FsControl fsControl = new FsControl(sqlScript.getParent().toFile());
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(bn, Localizer.getCurrentLocale(), fsControl);
            return Optional.of(bundle);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

